/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.gamelogic;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RunnableAction;
import com.badlogic.gdx.utils.Array;
import com.skloch.game.gamelogic.Energy;
import com.skloch.game.gamelogic.Player;
import com.skloch.game.gamelogic.Time;
import com.skloch.game.scoring.Achievement;
import com.skloch.game.scoring.Score;
import com.skloch.game.screens.GameScreen;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;

public class EventManager {
    private final GameScreen game;
    private final Time time;
    private final Player player;
    public HashMap<String, Integer> activityEnergies;
    private final HashMap<String, String> objectInteractions;
    private final Array<String> talkTopics;
    Score score = Score.getInstance();
    private Energy energyBar;
    private boolean studiedToday = false;
    private boolean walkedToday = false;
    private boolean catchUpUsed = false;
    private boolean missedDay = false;
    private int dayLastStudied = 0;
    private int dayLastBus = 0;
    private int dayLastWalked = 0;
    private int timeLastEat = 0;
    public boolean ronCookePrevious = false;
    public boolean ronCookeCurrent;

    public EventManager(GameScreen game, Energy energyBar, Time time, Player player) {
        this.game = game;
        this.time = time;
        this.energyBar = energyBar;
        this.player = player;
        this.activityEnergies = new HashMap();
        this.activityEnergies.put("studying", 40);
        this.activityEnergies.put("meet_friends", 10);
        this.activityEnergies.put("walk", 30);
        this.activityEnergies.put("ducks", 20);
        this.activityEnergies.put("eating", 10);
        this.activityEnergies.put("bar", 20);
        this.objectInteractions = new HashMap();
        this.objectInteractions.put("ron_cooke", "Study in the Ron Cooke building?");
        this.objectInteractions.put("friends", "Talk to your friends?");
        this.objectInteractions.put("accomodation", "Go to sleep for the night?\nYour alarm is set for 8am.");
        this.objectInteractions.put("piazza", null);
        this.objectInteractions.put("tree", "Speak to the tree?");
        this.objectInteractions.put("walk", "Go on a walk in the woods?");
        this.objectInteractions.put("ducks", "Feed the ducks?");
        this.objectInteractions.put("busCampus", "Get the bus to town?");
        this.objectInteractions.put("busTown", "Get the bus back to campus?");
        this.objectInteractions.put("library", "Study at the library?");
        this.objectInteractions.put("restaurant", "Eat at the restaurant?");
        this.objectInteractions.put("bar", "Play pool at the bar with your friends?");
        String[] topics = new String[]{"Dogs", "Cats", "Exams", "Celebrities", "Flatmates", "Video games", "Sports", "Food", "Fashion"};
        this.talkTopics = new Array<String>(topics);
    }

    public void event(String eventKey) {
        String[] args = eventKey.split("-");
        if (args[0] == "fadefromblack") {
            this.fadeFromBlack();
        } else if (args[0] == "fadetoblack") {
            this.fadeToBlack();
        } else if (args[0] == "gameover") {
            this.game.gameOver();
        }
        switch (args[0]) {
            case "tree": {
                this.treeEvent();
                break;
            }
            case "friends": {
                this.friendsEvent(args);
                break;
            }
            case "ron_cooke": {
                this.ronCookeCurrent = true;
                this.ronCookeEvent(args);
                break;
            }
            case "piazza": {
                this.piazzaEvent(args);
                break;
            }
            case "accomodation": {
                this.accomEvent(args);
                break;
            }
            case "walk": {
                this.walk(args);
                break;
            }
            case "ducks": {
                this.ducks(args);
                break;
            }
            case "busCampus": {
                this.busCampus(args);
                break;
            }
            case "busTown": {
                this.busTown(args);
                break;
            }
            case "library": {
                this.ronCookeCurrent = false;
                this.ronCookeEvent(args);
                break;
            }
            case "restaurant": {
                this.piazzaEvent(args);
                break;
            }
            case "bar": {
                this.bar(args);
                break;
            }
            case "exit": {
                this.game.hideDialogueBox();
                break;
            }
            default: {
                this.objectEvent(eventKey);
            }
        }
    }

    public String getObjectInteraction(String key) {
        if (key.equals("piazza")) {
            return String.format("Eat %s at the Piazza Building?", this.time.getMeal());
        }
        return this.objectInteractions.get(key);
    }

    public boolean hasCustomObjectInteraction(String key) {
        return this.objectInteractions.containsKey(key);
    }

    public void treeEvent() {
        this.game.hideDialogueSelectBox();
        this.game.setDialogueBoxText("The tree doesn't say anything back.");
        if (!Achievement.getInstance().checkAchievement(1)) {
            Achievement.getInstance().giveAchievement(1);
            this.score.incrementTotalScore(5, 100);
        }
    }

    public void objectEvent(String object) {
        this.game.hideDialogueSelectBox();
        this.game.setDialogueBoxText("This is a " + object + "!");
    }

    public void friendsEvent(String[] args) {
        int energyCost = this.activityEnergies.get("meet_friends");
        if (this.energyBar.getEnergy() < energyCost) {
            this.game.setDialogueBoxText("You are too tired to meet your friends right now!");
        } else if (args.length == 1) {
            String[] topics = this.randomTopics(3);
            this.game.setDialogueBoxText("What do you want to chat about?");
            this.game.setDialogueBoxOptions(topics, new String[]{"friends-" + topics[0], "friends-" + topics[1], "friends-" + topics[2]});
        } else {
            int hours = ThreadLocalRandom.current().nextInt(1, 4);
            this.game.setDialogueBoxText(String.format("You talked about %s for %d hours!", args[1].toLowerCase(), hours));
            this.score.incrementNumRecreationalFriends();
            this.score.incrementTotalScore(3, this.score.activityScore(0, this.time.day));
            this.energyBar.decreaseEnergy(energyCost * hours);
            this.time.passTime(hours * 60);
            this.time.addRecreationalHours(hours);
        }
    }

    private String[] randomTopics(int amount) {
        Array<String> topics = new Array<String>(amount);
        for (int i = 0; i < amount; ++i) {
            String choice = this.talkTopics.random();
            if (!topics.contains(choice, false)) {
                topics.add(choice);
                continue;
            }
            --i;
        }
        return topics.toArray(String.class);
    }

    public void ronCookeEvent(String[] args) {
        if (this.dayLastStudied < this.time.day) {
            this.studiedToday = false;
        }
        if (this.time.day - this.dayLastStudied > 1) {
            this.missedDay = true;
        }
        int energyCost = this.activityEnergies.get("studying");
        if (this.energyBar.getEnergy() < energyCost) {
            this.game.hideDialogueSelectBox();
            this.game.setDialogueBoxText("You are too tired to study right now!");
        } else if (this.energyBar.getEnergy() < energyCost) {
            this.game.setDialogueBoxText("You don't have the energy to study for this long!");
        } else if (!this.studiedToday) {
            this.studiedToday = true;
            this.dayLastStudied = this.time.day;
            this.game.setDialogueBoxText(String.format("You studied for 6 hours!\nYou lost %d energy", energyCost));
            this.energyBar.decreaseEnergy(energyCost);
            this.time.addStudyHours(6);
            this.time.passTime(360.0f);
            if (this.ronCookeCurrent) {
                if (!this.ronCookePrevious) {
                    this.score.incrementTotalScore(2, 500);
                } else {
                    this.score.incrementTotalScore(2, 300);
                }
                this.ronCookePrevious = true;
            } else {
                if (this.ronCookePrevious || this.score.getNumStudying() == 0) {
                    this.score.incrementTotalScore(2, 500);
                } else {
                    this.score.incrementTotalScore(2, 300);
                }
                this.ronCookePrevious = false;
            }
            this.score.incrementNumStudying();
            if (Achievement.getInstance().bookwormAchievement(this.score.getNumStudying())) {
                this.score.incrementTotalScore(5, 100);
            }
        } else if (this.missedDay && !this.catchUpUsed) {
            this.catchUpUsed = true;
            this.dayLastStudied = this.time.day;
            this.game.setDialogueBoxText(String.format("You caught up for 6 hours!\nYou lost %d energy", energyCost));
            this.energyBar.decreaseEnergy(energyCost);
            this.time.addStudyHours(6);
            this.time.passTime(360.0f);
            this.score.incrementTotalScore(2, 300);
            this.score.incrementNumStudying();
            if (Achievement.getInstance().bookwormAchievement(this.score.getNumStudying())) {
                this.score.incrementTotalScore(5, 100);
            }
        } else {
            this.game.setDialogueBoxText("You've already studied as much as you can for today!");
        }
    }

    public void piazzaEvent(String[] args) {
        int energyCost = this.activityEnergies.get("eating");
        if (this.energyBar.getEnergy() < energyCost) {
            this.game.setDialogueBoxText("You are too tired to eat right now!");
        } else {
            this.game.setDialogueBoxText(String.format("You took 1 hour to eat %s!\nYou lost %d energy!", this.time.getMeal(), energyCost));
            this.energyBar.decreaseEnergy(energyCost);
            this.score.incrementTotalScore(1, this.score.hungerScore(Math.round(this.time.daySeconds), this.timeLastEat));
            this.timeLastEat = (int)this.time.getSeconds();
            this.score.incrementNumEating();
            this.time.passTime(60.0f);
        }
    }

    public void accomEvent(String[] args) {
        this.game.setSleeping(true);
        this.game.hideDialogueBox();
        final float secondsSlept = this.time.getSeconds() < 480.0f ? 480.0f - this.time.getSeconds() : 1920.0f - this.time.getSeconds();
        final int hoursSlept = Math.round(secondsSlept / 60.0f);
        this.timeLastEat = 0;
        RunnableAction setTextAction = new RunnableAction();
        setTextAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                if (EventManager.this.game.getSleeping()) {
                    EventManager.this.game.showDialogueBox();
                    EventManager.this.game.setDialogueBoxText(String.format("You slept for %d hours!\nYou recovered %d energy!", hoursSlept, Math.min(100, hoursSlept * 13)), "fadefromblack");
                    EventManager.this.energyBar.setEnergy(hoursSlept * 13);
                    EventManager.this.score.incrementTotalScore(4, Math.min(hoursSlept * 50, 500));
                    EventManager.this.time.passTime(secondsSlept);
                    EventManager.this.time.addSleptHours(hoursSlept);
                    EventManager.this.score.incrementNumSleeping();
                }
            }
        });
        this.fadeToBlack(setTextAction);
    }

    public void walk(String[] args) {
        if (this.dayLastWalked < this.time.day) {
            this.walkedToday = false;
        }
        final int energyCost = this.activityEnergies.get("walk");
        if (this.energyBar.getEnergy() < energyCost) {
            this.game.setDialogueBoxText("You are too tired to go on a walk right now!");
        } else {
            this.game.setFadeout(true);
            this.game.hideDialogueBox();
            RunnableAction setTextAction = new RunnableAction();
            setTextAction.setRunnable(new Runnable(){

                @Override
                public void run() {
                    EventManager.this.game.showDialogueBox();
                    EventManager.this.game.setDialogueBoxText(String.format("You went on a walk for 4 hours!\nYou lost %d energy!", energyCost), "fadefromblack");
                    EventManager.this.energyBar.decreaseEnergy(energyCost);
                    EventManager.this.score.incrementTotalScore(3, EventManager.this.score.activityScore(1, ((EventManager)EventManager.this).time.day));
                    EventManager.this.time.passTime(240.0f);
                    if (!EventManager.this.walkedToday) {
                        EventManager.this.walkedToday = true;
                        EventManager.this.dayLastWalked = ((EventManager)EventManager.this).time.day;
                        EventManager.this.score.incrementNumRecreationalWalk();
                        if (Achievement.getInstance().joggerAchievement(EventManager.this.score.getNumRecreationalWalk())) {
                            EventManager.this.score.incrementTotalScore(5, 100);
                        }
                    }
                }
            });
            this.fadeToBlack(setTextAction);
        }
    }

    public void busCampus(String[] args) {
        if (this.dayLastBus == this.time.day) {
            this.game.setDialogueBoxText("There are no more busses running today!");
        } else {
            this.score.incrementNumBus();
            this.game.setFadeout(true);
            this.game.hideDialogueBox();
            RunnableAction setTextAction = new RunnableAction();
            setTextAction.setRunnable(new Runnable(){

                @Override
                public void run() {
                    EventManager.this.game.showDialogueBox();
                    EventManager.this.game.setDialogueBoxText(String.format("You got the bus into town, which took an hour!", new Object[0]), "fadefromblack");
                    EventManager.this.time.passTime(60.0f);
                    EventManager.this.player.setPos(((EventManager)EventManager.this).game.townSpawn[0], ((EventManager)EventManager.this).game.townSpawn[1]);
                }
            });
            this.fadeToBlack(setTextAction);
        }
        this.dayLastBus = this.time.day;
    }

    public void busTown(String[] args) {
        this.game.setFadeout(true);
        this.game.hideDialogueBox();
        RunnableAction setTextAction = new RunnableAction();
        setTextAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                EventManager.this.game.showDialogueBox();
                EventManager.this.game.setDialogueBoxText(String.format("You got the bus to campus, which took an hour!", new Object[0]), "fadefromblack");
                EventManager.this.time.passTime(60.0f);
                EventManager.this.player.setPos(((EventManager)EventManager.this).game.campusSpawn[0], ((EventManager)EventManager.this).game.campusSpawn[1]);
            }
        });
        this.fadeToBlack(setTextAction);
    }

    public void ducks(String[] args) {
        int energyCost = this.activityEnergies.get("ducks");
        if (this.energyBar.getEnergy() < energyCost) {
            this.game.setDialogueBoxText("You are too tired to feed the ducks right now!");
        } else {
            this.game.showDialogueBox();
            this.game.setDialogueBoxText(String.format("You fed the ducks for 3 hours!\nYou lost %d energy!", energyCost));
            this.energyBar.decreaseEnergy(energyCost);
            this.score.incrementTotalScore(3, this.score.activityScore(2, this.time.day));
            this.score.incrementNumRecreationalDuck();
            if (Achievement.getInstance().duckDuckGoAchievement(this.score.getNumRecreationalDuck())) {
                this.score.incrementTotalScore(5, 100);
            }
            this.time.passTime(180.0f);
        }
    }

    public void bar(String[] args) {
        int energyCost = this.activityEnergies.get("bar");
        if (this.energyBar.getEnergy() < energyCost) {
            this.game.setDialogueBoxText("You are too tired to play pool right now!");
        } else {
            this.game.showDialogueBox();
            this.game.setDialogueBoxText(String.format("You played pool for 3 hours!\nYou lost %d energy!", energyCost));
            this.energyBar.decreaseEnergy(energyCost);
            this.score.incrementTotalScore(3, this.score.activityScore(3, this.time.day));
            this.score.incrementNumRecreationalBar();
            this.time.passTime(180.0f);
        }
    }

    public void fadeToBlack() {
        this.game.addActionToBlackscreen(Actions.fadeIn(3.0f));
    }

    public void fadeToBlack(RunnableAction runnable) {
        this.game.addActionToBlackscreen(Actions.sequence((Action)Actions.fadeIn(3.0f), (Action)runnable));
    }

    public void fadeFromBlack() {
        if (this.game.getSleeping()) {
            RunnableAction setTextAction = new RunnableAction();
            setTextAction.setRunnable(new Runnable(){

                @Override
                public void run() {
                    if (EventManager.this.game.getSleeping()) {
                        EventManager.this.game.showDialogueBox();
                        EventManager.this.game.setDialogueBoxText(EventManager.this.time.getWakeUpMessage());
                        EventManager.this.game.setSleeping(false);
                    }
                }
            });
            this.game.addActionToBlackscreen(Actions.sequence((Action)Actions.fadeOut(3.0f), (Action)setTextAction));
        } else {
            this.game.addActionToBlackscreen(Actions.fadeOut(3.0f));
        }
        this.game.setFadeout(false);
    }
}

